/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: OS_Includes.h $
   Last Modification:
    $Author: Robert $
    $Modtime: 30.07.07 16:02 $
    $Revision: 2781 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
     Headerfile for specific operating system includes (currently windows only)
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     4         02.03.2011  SS       Warning "conditional expression is constant" disabled
     3         10.04.2007  RM       "typedef uint32_t UINT32" removed
     2         22.03.2007  MT       Added proper header files for CIFx Device driver build
     1         08.08.2006  MT       initial version (Windows only)
 
**************************************************************************************/

#ifndef __OS_INCLUDES__H
#define __OS_INCLUDES__H

#if _MSC_VER >= 1000
  #ifndef CIFX_DRIVER
    #include "windows.h"
    #ifdef CIFX_TOOLKIT_HWIF    
      #pragma warning (disable: 4127)
    #endif
  #else
    #pragma warning (disable: 4214 4201)
    #include "windef.h"
  #endif
#else

  #error "TODO: Define all neccessary typedefinitions, and add include files"

/* The following types need to be defined

  APIENTRY
  UINT32
*/
  #define APIENTRY

  #ifndef NULL
    #define NULL 0
  #endif

#endif

#ifndef UNREFERENCED_PARAMETER
  #define UNREFERENCED_PARAMETER(a) (a=a)
#endif

#endif /* __OS_INCLUDES__H */
